//////////////////////////////////////////////////////////////////////////////////////////////
// sept_heimdall_onconnection - Base script called by msgServer plugin to start the whole heimdall process
//
// Based on Crom's work.
//--------------------------------------------------------------------------------------------
// Last modified by :  	Septirage		2025/09/13
//////////////////////////////////////////////////////////////////////////////////////////////

#include "sept_heimdall_include"


int StartingConditional(int iUniquePlayerID, string sPlayerName, string sIP, string sCDKey, int iPrivileges)
{
	object oModule = GetModule();

	if (GetLocalInt(oModule, "sept_heimdall_init") == FALSE) {
		Heimdall_ModuleInit();
		SetLocalInt(oModule, "sept_heimdall_init", TRUE);
	}
	
	int bLockedOut = FALSE;

	if (GetLocalInt(oModule, SEPT_HEIMDALL_RETRIES + sPlayerName + "@" + sIP) >= SEPT_HEIMDALL_SECURITY_BADPASSWORD_RETRIES) {
		// Too many failed login attempts
		//Heimdall_OpenKickGui(iUniquePlayerID, sPlayerName, sIP, sCDKey, iPrivileges, SEPT_HEIMDALL_MSG_LOGINBLOCKED);
		//return XPMSGSRV_HEIMDALL_RET_KICK;
		bLockedOut = TRUE;
	}

	if (!bLockedOut && Heimdall_IsRemembered(sPlayerName, sIP, sCDKey, iPrivileges)) {
		string sErr = Heimdall_IsLoginAllowed(sPlayerName, sIP, sCDKey, iPrivileges);
		if (sErr != "") {
			Heimdall_OpenKickGui(iUniquePlayerID, sPlayerName, sIP, sCDKey, iPrivileges, sErr);
			return XPMSGSRV_HEIMDALL_RET_KICK;
		}
		// Bypass login if player has logged in with "remember me" ticked
		return XPMSGSRV_HEIMDALL_RET_ALLOW;
	}

	string sKnownAccountName = Heimdall_GetRegisteredAccount(sPlayerName, sIP, sCDKey, iPrivileges);

	if (sKnownAccountName == "") {
		if (SEPT_HEIMDALL_ALLOW_REGISTRATION) {
			// Check account policy and kick if unacceptable
			string sErr = Heimdall_CheckAccountPolicy(sPlayerName, sIP, sCDKey, iPrivileges);
			if (sErr != "") {
				Heimdall_OpenKickGui(iUniquePlayerID, sPlayerName, sIP, sCDKey, iPrivileges, sErr);
				return XPMSGSRV_HEIMDALL_RET_KICK;
			}

			// Open registration form
			Heimdall_OpenRegisterGUI(iUniquePlayerID, sPlayerName, sIP, sCDKey, iPrivileges);
			return XPMSGSRV_HEIMDALL_RET_WAIT;
		} else {
			// Kick the player and ask to register elsewhere
			Heimdall_OpenKickGui(iUniquePlayerID, sPlayerName, sIP, sCDKey, iPrivileges, SEPT_HEIMDALL_MSG_KICK_NEEDREGISTRATION);
			return XPMSGSRV_HEIMDALL_RET_KICK;
		}
	}

	if (sKnownAccountName != sPlayerName) {
		// Account case issue: kick the player and require to connect with correct account
		string sMsg = ReplaceTokens(SEPT_HEIMDALL_MSG_KICK_BADCASE, "{{CORRECT_ACCOUNT}}", sKnownAccountName);
		Heimdall_OpenKickGui(iUniquePlayerID, sPlayerName, sIP, sCDKey, iPrivileges, sMsg);
		return XPMSGSRV_HEIMDALL_RET_KICK;
	}

	string sErr = Heimdall_IsLoginAllowed(sPlayerName, sIP, sCDKey, iPrivileges);
	if (sErr != "") {
		Heimdall_OpenKickGui(iUniquePlayerID, sPlayerName, sIP, sCDKey, iPrivileges, sErr);
		return XPMSGSRV_HEIMDALL_RET_KICK;
	}

	// Open login form
	Heimdall_OpenLoginGUI(iUniquePlayerID, sPlayerName, sIP, sCDKey, iPrivileges);
	if(bLockedOut) {
		Heimdall_ShowErrorMessage(iUniquePlayerID, SEPT_HEIMDALL_LOGIN_SCENENAME, sPlayerName, sIP, sCDKey, iPrivileges, SEPT_HEIMDALL_MSG_LOGINBLOCKED);
	}
	
	return XPMSGSRV_HEIMDALL_RET_WAIT;
}